# Cuadro I.3
# Clculo de coordenadas polares
# Grfica correpondiente


########################################################
# Seccin modificable por el usuario
########################################################
# Lectura de la base de datos
datos<-read.csv2("Cuadro I.3.V.csv",encoding="latin1")

# Seleccin de las variables de inters
varInteres<-c("Funcin.1","Funcin.2","Funcin.3","Funcin.4","Funcin.5")

# Seleccin de las variables de identificacin
varID<-c("Especie")
# varID<-NULL

# Seleccin de la variable de agrupacin
varAgrupa<-c("Especie")
#varAgrupa<-NULL

# Nombre del archivo de salida con coodenadas polares
nomCoorPol<-("Salida Cuadro I.3-1.V.csv")

# Nombre del archivo de salida con resumen de las coordenadas polares
# si se coloca una variable de agrupacin
nomResumenCoordPol<-("Salida Cuadro I.3-2.V.csv")

# Ttulo de la grfica
grafTitulo<-"Grfica de coordenadas polares"

# Ttulo de la grfica de los datos agrupados
grafTituloAg<-"Grfica de coordenadas polares agrupada"

# Opcin de ordenacin de acuerdo al algoritmo propuesto
ordenar<-"No"



########################################################
# Seccin que realiza el procedimiento
########################################################


# Funciones auxiliares

# Funcin auxiliar para calcular el valor de la coordenada X
# Funciona tanto para los casos que las variables tengan
# valores negativos
cx<-function(x,angulos){
  if (length(x)==length(angulos)) angulos<-c(angulos,angulos)
  x[length(x)]<-(-x[length(x)])
  x1<-abs(x)*cos(angulos[1:(length(angulos)/2)])*(x>0)
  x2<-abs(x)*cos(angulos[(length(angulos)/2+1):length(angulos)])*(x<=0)
  x<-x1+x2
  return(sum(x))
}

cy<-function(y,angulos){
  if (length(y)==length(angulos)) angulos<-c(angulos,angulos)
  y[length(y)]<-(-y[length(y)])
  y1<-abs(y)*sin(angulos[1:(length(angulos)/2)])*(y>0)
  y2<-abs(y)*sin(angulos[(length(angulos)/2+1):length(angulos)])*(y<=0)
  y<-y1+y2
  return(sum(y))
}

# Funcin para graficar resultados de las
# coordenadas polares
plotPolar<-function(Bcoord,BId,vars,angulos,titulo="",limitemax)
{
 ifelse(dim(BId)[2]>1,codifID<-apply(format(BId),1,paste,collapse="-"),codifID<-BId[,1])
 coordenadas<-Bcoord[,c(1,2)]
 varNeg<-(sum(coordenadas<0)!=0)
 # limitemax<-max(apply(coordenadas,1,function(x) sqrt(sum(x^2))))*1.5
 org<-matrix(rep(c(0,0),length(vars)+length(vars)*varNeg),length(vars)+length(vars)*varNeg,2)
 dest<-org
 dest[,1]<-limitemax*0.9*cos(angulos)
 dest[,2]<-limitemax*0.9*sin(angulos)
 plot.new()
 pin <- par("pin")
    xlim <- ylim <- c(-limitemax,limitemax)
    if (pin[1L] > pin[2L]) 
        xlim <- (pin[1L]/pin[2L]) * xlim
    else ylim <- (pin[2L]/pin[1L]) * ylim
 plot.window(xlim,ylim,"",asp=1)
 title(titulo)
 text(coordenadas,xlim=xlim,ylim=ylim,labels=codifID)
 segments(org[,1],org[,2],dest[,1],dest[,2],col="gray")
 symbols(0,0,circles=limitemax*.9,add=T,inches=F)
 dest[,1]<-limitemax*1.05*cos(angulos)
 dest[,2]<-limitemax*1.05*sin(angulos)
 text(dest[,1],dest[,2],labels=vars)
 invisible(NULL)
}

# Funciones y clculos para el caso de variables agrupadas

summaryCoordPol<-function(coordenadas,BAg){
  nAg<-dim(BAg)[2]
  medias<-aggregate(coordenadas,BAg,mean)
  dest<-aggregate(coordenadas,BAg,sd)
  errorest<-aggregate(coordenadas,BAg,function(x) sd(x)/sqrt(length(x)))
  names(medias)[(nAg+1):(nAg+2)]<-c("X mean","Y mean")
  names(dest)[(nAg+1):(nAg+2)]<-c("X sd","Y sd")
  names(errorest)[(nAg+1):(nAg+2)]<-c("X err","Y err")
  summary1<-data.frame(medias,dest[,(nAg+1):(nAg+2)],errorest[,(nAg+1):(nAg+2)])
  return(summary1)
}


# Toma decisiones en cuanto a la organizacin
# del procedimiento

if (is.null(varID) & is.null(varAgrupa)) stop("Debe tener al menos variables de identificacin o de agrupacin")
if (is.null(varID) & !is.null(varAgrupa)) varID<-varAgrupa

# Omitir valores faltantes
if (!is.null(varAgrupa)) total<-na.omit(data.frame(datos[,varID],datos[,varAgrupa],datos[,varInteres])) else total<-na.omit(data.frame(datos[,varID],datos[,varInteres]))
if (length(varID)==1) names(total)[1]<-varID
if (length(varAgrupa)==1) names(total)[(length(varID)+1)]<-varAgrupa

# Dividir de nuevo la base de datos para los distintos propsitos.
baseVar<-total[,varInteres]
baseID<-total[,varID]
if(length(varID)==1) {baseID<-data.frame(baseID);names(baseID)<-varID}
if (!is.null(varAgrupa)) {
    baseAgrupa<-total[,varAgrupa]
    if(length(varAgrupa)==1) {baseAgrupa<-data.frame(baseAgrupa);names(baseAgrupa)<-varAgrupa}
    }

# Verificar si hay variables con valores negativos.
# Si los hay entonces no realiza la ordenacin.
# Y si por el contrario no existen valores negativos
# entonces necesariamente los ordena con el criterio propuesto.
varNeg<-(sum(baseVar<0)!=0)

if (toupper(ordenar)=="SI") {
  # Clculo de coeficiente de variacin mximo
  medias<-apply(baseVar,2,mean)
  dsv<-apply(baseVar,2,sd)
  cv1<-order(dsv/medias,decreasing=T)
  CVmax<-names(baseVar[,cv1])[1]
  posPivote<-cv1[1]

  # Clculo de distancias
  distancias<-as.matrix(dist(t(baseVar),upper=T,diag=T))
  distancias<-distancias+diag(dim(distancias)[1])*max(distancias)

  # Inicializacin de variables
  ordenV<-CVmax
  ordenD<-NULL
  # Ordenacin por distancias
  for (i in 1:(dim(distancias)[1]-2)) {
  ordenD<-c(ordenD,min(distancias[posPivote,]))
  distMinN<-which(min(distancias[posPivote,])==distancias[posPivote,])
  ordenV<-c(ordenV,rownames(distancias)[distMinN])
  distancias<-distancias[-posPivote,-posPivote]
  posPivote<-which(ordenV[length(ordenV)]==rownames(distancias))
  }
  ordenV<-c(ordenV,names(baseVar)[!(names(baseVar) %in% ordenV)])
  ordenD<-c(ordenD,distancias[ordenV[length(ordenV)-1],ordenV[length(ordenV)]])
  baseVar<-baseVar[,ordenV]
  varInteres<-ordenV
}

# Clculos para establecer las coordenadas polares
# Clculo de los ngulos
# Nmero total de variables
nvar<-length(varInteres)
# Si todos los valores son positivos se centra a 0.5
if (!varNeg) baseVar<-baseVar-0.5; varNeg<-TRUE
# Clculo del nmero de ngulos si hay valores negativos
nvar<-nvar+nvar*varNeg
# Clculo de cada uno de los ngulos en radianes
angulos<-seq(0,2*pi,l=nvar+1)[-1]


# Clculo de las coordenadas cartesianas de las coordenadas polares
X<-apply(baseVar,1,cx,angulos)
Y<-apply(baseVar,1,cy,angulos)

# Generacin de las coordenadas polares completas
coordPolares<-data.frame(X,Y)

# Une las coodenadas polares con las variables de identificacin
# Para su posterior grabacin
coordPolaresID<-data.frame(baseID,coordPolares)

# Une las coordenadas polares con las variables de agrupacin
# Para su posterior procesamiento
if (!(is.null(varAgrupa))) coordPolaresAg<-data.frame(baseAgrupa,baseVar)

# Resmenes por Agrupacin
if (!(is.null(varAgrupa))) resumenCoordAg<-summaryCoordPol(coordPolares,baseAgrupa)

# Bases para la graficacin por agrupacin
if (!(is.null(varAgrupa))){
coordPolaresAg<-data.frame(resumenCoordAg[,c("X.mean","Y.mean")])
baseAg<-data.frame(resumenCoordAg[,varAgrupa])
if(length(varAgrupa)==1) names(baseAg)<-varAgrupa
}

limitemax<-max(apply(coordPolares[,c(1,2)],1,function(x) sqrt(sum(x^2))))*1.5

########################################################
# Seccin que muestra los resultados
########################################################

# Graba el resultado con las coordenadas por identificacin
write.csv2(coordPolaresID,nomCoorPol,row.names=F)

# Graba el resultado con las coordenadas agrupadas.
if(!(is.null(varAgrupa))) write.csv2(resumenCoordAg,nomResumenCoordPol,row.names=F)

# Grafica las coordenadas polares utilizando la variable identificacin
# Muestra la grfica correspondiente a las coordenadas polares.

plotPolar(coordPolares,baseID,varInteres,angulos,grafTitulo,limitemax)


# Grafica las coordenadas polares utilizando la variable identificacin
# Muestra la grfica correspondiente a las coordenadas polares, Agrupada
if(!(is.null(varAgrupa))) {
x11()
plotPolar(coordPolaresAg,baseAg,varInteres,angulos,grafTituloAg,limitemax)
}
par(ask=FALSE)

